/*
 * ErrorTraceManager.cpp
 *
 *  Created on: 06.06.2011
 *      Author: stefan.detter
 */

#include "ErrorTraceManager.h"

#include <QDesktopServices>
#include <QDir>
#include <QSettings>

#include <QrfeTrace>
#include <QrfeRingFile>

#include <def.h>


ErrorTraceManager::ErrorTraceManager(QObject* parent)
	: QObject(parent)
	, QrfeTraceModule("ErrorTraceManager")
{
	QSettings set(QSettings::IniFormat, QSettings::UserScope, COMPANY_NAME, "ErrorTrace");
	QString path;
	path = set.fileName().remove(".ini");

	QDir dir;
	if(!dir.exists(path))
		dir.mkpath(path);

	trc(0, "File Path: " + path);

	m_file = new QrfeRingFile(path, "ErrorTraceFile_", "txt", 2, 10 * 1024);
	m_file->setAppend(true);
	m_file->setRisingNumber(true);
	m_file->open(QIODevice::WriteOnly);

	connect(QrfeTrace::getInstance(), 	SIGNAL(errorSignal(const QString&)),
			this, 						  SLOT(traceError(const QString&)));
}

ErrorTraceManager::~ErrorTraceManager()
{
	delete m_file;
}

void ErrorTraceManager::traceError(const QString& err)
{
	m_file->write(err.toLatin1() + "\r\n");
    m_file->flush();
}
